﻿@imports Resources
@ModelType UserPoco
@Code
    ViewData("Title") = Strings.Delete_Title
End Code

<div class="container mt-4" style="max-width: 800px;">
    <h2>@Strings.Delete_Title</h2>
    <hr />

    @* A clear warning message is crucial for a delete action *@
    <div class="alert alert-danger">
        <h4 class="alert-heading">@Strings.Delete_ConfirmationRequired</h4>
        <p>@Strings.Delete_Warning <strong>@Model.LoginName</strong>? @Strings.Delete_CannotBeUndone</p>
    </div>

    @* Display the details of the user being deleted inside a card for clarity *@
    <div class="card">
        <div class="card-header fw-bold">
            @Strings.Delete_UserDetails
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-sm-4"><strong>@Strings.Delete_LoginNameLabel</strong></div>
                <div class="col-sm-8">@Html.DisplayFor(Function(model) model.LoginName)</div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-4"><strong>@Strings.Delete_LastLoginLabel</strong></div>
                <div class="col-sm-8">@Html.DisplayFor(Function(model) model.LastLoginTimeStamp)</div>
            </div>
            <div class="row">
                <div class="col-sm-4"><strong>@Strings.Delete_IsPortalAdminLabel</strong></div>
                <div class="col-sm-8">
                    @If Model.IsWOLPortalAdmin Then
                        @<span class="badge bg-success">@Strings.Delete_Yes</span>
                    Else
                        @<span class="badge bg-secondary">@Strings.Delete_No</span>
                    End If
                </div>
            </div>
        </div>
    </div>

    @* The form for submitting the delete action *@
    @Using (Html.BeginForm())
        @Html.AntiForgeryToken()

        @<div class="mt-4">
            <input type="submit" value="@Strings.Delete_ConfirmDeleteButton" class="btn btn-danger" />
            @Html.ActionLink(Strings.Delete_CancelButton, "Index", Nothing, New With {.class = "btn btn-secondary ms-2"})
        </div>
    End Using
</div>