﻿@imports Resources
@ModelType UserPoco
@Code
    ViewData("Title") = Strings.Admin_UserDetails
End Code

<div class="container mt-4" style="max-width: 800px;">
    <h2>@Strings.Admin_UserDetails</h2>
    <hr />

    @* Card for primary user information *@
    <div class="card mb-4">
        <div class="card-header fw-bold">
            @Strings.Admin_AccountInformation
        </div>
        <div class="card-body">
            <div class="row mb-2">
                <div class="col-sm-4 fw-bold">@Strings.Delete_LoginNameLabel</div>
                <div class="col-sm-8">@Html.DisplayFor(Function(model) model.LoginName)</div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-4 fw-bold">@Strings.Delete_LastLoginLabel</div>
                <div class="col-sm-8">@Html.DisplayFor(Function(model) model.LastLoginTimeStamp)</div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-4 fw-bold">@Strings.Admin_IsPortalAdmin</div>
                <div class="col-sm-8">
                    @If Model.IsWOLPortalAdmin Then
                        @<span class="badge bg-success">@Strings.Admin_Yes</span>
                    Else
                        @<span class="badge bg-secondary">@Strings.Admin_No</span>
                    End If
                </div>
            </div>
            <div class="row">
                <div class="col-sm-4 fw-bold">@Strings.Admin_IsStatusViewer</div>
                <div class="col-sm-8">
                    @If Model.IsGroupDataReader Then
                        @<span class="badge bg-success">@Strings.Admin_Yes</span>
                    Else
                        @<span class="badge bg-secondary">@Strings.Admin_No</span>
                    End If
                </div>
            </div>
        </div>
    </div>

    @* Card for the list of assigned PCs *@
    <div class="card">
        <div class="card-header fw-bold">
            @Strings.Admin_AssignedPCs
        </div>
        @* Check if there are any PCs to display *@
        @If Model.PCs IsNot Nothing AndAlso Model.PCs.Any() Then
            @<ul class="list-group list-group-flush">
                @* Loop through and display each PC name *@
                @For Each pc As PcPoco In Model.PCs.OrderBy(Function(p) p.PCName)
                    If Not String.IsNullOrWhiteSpace(pc.PCName) Then
                        @<li class="list-group-item">@Html.DisplayFor(Function(model) pc.PCName)</li>
                    End If
                Next
            </ul>
        Else
            @* Show a message if no PCs are assigned *@
            @<div class="card-body">
                <p class="card-text text-muted">@Strings.Admin_NoPCsAssignedToUser</p>
            </div>
        End If
    </div>

    @* Action buttons at the bottom *@
    <div class="mt-4">
        @Html.ActionLink(Strings.Admin_Edit, "Edit", New With {.id = Model.ID}, New With {.class = "btn btn-primary"})
        @Html.ActionLink(Strings.Admin_BackToList, "Index", Nothing, New With {.class = "btn btn-secondary ms-2"})
    </div>
</div>