﻿@*@ModelType IEnumerable(Of UserPoco)*@
@ModelType PagedList.IPagedList(Of UserPoco)
@Imports PagedList.Mvc
@Imports Resources
@Imports Resources

@Code
    ViewData("Title") = Strings.Admin_UserManager_Title
    '  Dim userlogin As String = ViewData("userLoginName")
End Code

<h2>@Strings.Admin_UserManager_Title</h2>

<p>
    @If Model.Count > 20 Then
        @<div class="mb-3">
            @Html.ActionLink(Strings.Admin_AddNewUser, "Create", Nothing, New With {.class = "btn btn-primary me-2"})
            @Html.ActionLink(Strings.Admin_BackToWOL, "BACKWOL", Nothing, New With {.class = "btn btn-secondary me-2"})
            @Using Html.BeginForm("Logout", "Home", FormMethod.Post, New With {.style = "display:inline;"})
                @Html.AntiForgeryToken()
                @<button type="submit" class="btn btn-outline-danger">@Strings.Admin_Logout</button>
            End Using
        </div>
    End If

    <div Class="visible">
        @* --- CHANGE HERE: Changed FormMethod.Get to FormMethod.Post --- *@
        @Using (Html.BeginForm("Index", "Admin", FormMethod.Post, New With {.class = "row g-3 align-items-center mb-3"}))
            @Html.AntiForgeryToken()

            @<div class="col-auto">
                <span style="color:lightgray; font-size:small;">
                    @Strings.Admin_Filter_Help
                </span>
            </div>

            @<div class="row g-3 align-items-center mb-3">
                <div class="col-auto">
                    @Html.CheckBox("IsAdmin", CBool(ViewBag.CurrentAdminFilter), New With {.class = "form-check-input"})
                    @Html.Label("IsAdmin", Strings.Admin_IsAdmin, New With {.class = "form-check-label ms-1 me-3"})
                </div>
                <div class="col-auto">
                    @Html.CheckBox("IsViewer", CBool(ViewBag.CurrentViewerFilter), New With {.class = "form-check-input"})
                    @Html.Label("IsViewer", Strings.Admin_IsViewer, New With {.class = "form-check-label ms-1 me-3"})
                </div>
                <div class="col-auto">
                    @Html.TextBox("UserFilter", CStr(ViewBag.CurrentUserFilter), New With {.class = "form-control", .PlaceHolder = Strings.Admin_FilterByUser})
                </div>
                <div class="col-auto">
                    @Html.TextBox("PCFilter", CStr(ViewBag.CurrentPCFilter), New With {.class = "form-control", .PlaceHolder = Strings.Admin_FilterByPC})
                </div>
                <div class="col-auto">
                    <input type="submit" name="IndexButton" value="@Strings.Admin_Filter" class="btn btn-info me-2" />
                    <input type="submit" name="IndexButton" value="@Strings.Admin_ShowAll" class="btn btn-secondary me-2" />
                    <input type="submit" name="IndexButton" value="@Strings.Admin_ExportAll" class="btn btn-success" />
                </div>
            </div>
        End Using
    </div>
    <br />

    <table Class="table table-striped table-hover">
        <thead class="table-light">
            <tr>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_User)
                </th>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_LastLogin)
                </th>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_IsPortalAdmin)
                </th>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_IsStatusViewer)
                </th>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_PCsAssigned)
                </th>
                <th>
                    @Html.DisplayName(Strings.Admin_Table_Actions)
                </th>
            </tr>
        </thead>
        <tbody>
            @For Each item In Model
                @<tr>
                    <td>
                        @Html.DisplayFor(Function(modelItem) item.LoginName)
                        @Html.HiddenFor(Function(modelItem) item.pw)
                    </td>
                    <td>
                        @Html.DisplayFor(Function(modelItem) item.LastLoginTimeStamp)
                    </td>
                    <td>
                        @If item.IsWOLPortalAdmin Then
                            @<span class="badge bg-success">@Strings.Admin_Yes</span>
                        Else
                            @<span class="badge bg-secondary">@Strings.Admin_No</span>
                        End If
                    </td>
                    <td>
                        @If item.IsGroupDataReader Then
                            @<span class="badge bg-success">@Strings.Admin_Yes</span>
                        Else
                            @<span class="badge bg-secondary">@Strings.Admin_No</span>
                        End If
                    </td>
                    <td>
                        @code
                            Dim newLineNeeded As Boolean = False
                            If item.PCs IsNot Nothing AndAlso item.PCs.Count = 0 Then
                                @Html.Raw(Strings.Admin_NA)
                            ElseIf item.PCs IsNot Nothing Then
                                Dim sortedPCNames = From allpcs In item.PCs Select allpcs Order By allpcs.PCName Ascending
                                For Each pc In sortedPCNames
                                    If newLineNeeded Then
                                        @<br />
                                    End If
                                    @Html.Raw(pc.PCName)
                                    newLineNeeded = True
                                Next
                            Else
                                @Html.Raw(Strings.Admin_NA)
                            End If
                        End Code
                    </td>
                    <td>
                        @Html.ActionLink(Strings.Admin_Edit, "Edit", New With {.id = item.ID}, New With {.class = "btn btn-sm btn-outline-primary me-1"})
                        @Html.ActionLink(Strings.Admin_Details, "Details", New With {.id = item.ID}, New With {.class = "btn btn-sm btn-outline-info me-1"})
                        @Html.ActionLink(Strings.Admin_Delete, "Delete", New With {.id = item.ID}, New With {.class = "btn btn-sm btn-outline-danger"})
                    </td>
                </tr>
                            Next
        </tbody>
    </table>

    <br />
    @If Model.PageCount > 1 Then
        @<div class="d-flex justify-content-center">
            @Html.PagedListPager(Model, Function(page) Url.Action("Index", New With {.UserFilter = ViewBag.CurrentUserFilter, .PCFilter = ViewBag.CurrentPCFilter, .IsAdmin = ViewBag.CurrentAdminFilter, .IsViewer = ViewBag.CurrentViewerFilter, page}),
                                         New PagedListRenderOptions() With {
                                             .UlElementClasses = New List(Of String) From {"pagination"},
                                             .LiElementClasses = New List(Of String) From {"page-item"}
                                         })
        </div>
    End If

    <div class="mt-3">
        <b>
            @Html.ActionLink(Strings.Admin_AddNewUser, "Create", Nothing, New With {.class = "btn btn-primary me-2"})
            @Html.ActionLink(Strings.Admin_BackToWOL, "BACKWOL", Nothing, New With {.class = "btn btn-secondary me-2"})
            @Using Html.BeginForm("Logout", "Home", FormMethod.Post, New With {.style = "display:inline;"})
                @Html.AntiForgeryToken()
                @<button type="submit" class="btn btn-outline-danger">@Strings.Admin_Logout</button>
            End Using
        </b>
    </div>
</p>