@Imports Resources
@ModelType WEBPortal.ProcessWOLForSAMLUserViewModel
@Code       ViewData("Title") = Strings.WOLResultForSAMLUserResult_Title

    ' Sprachabhngiges Plural-Suffix fr "Sekunde{1}"/"second{1}"
    Dim lang = System.Threading.Thread.CurrentThread.CurrentUICulture.TwoLetterISOLanguageName.ToLowerInvariant()
    Dim secondsPluralSuffix As String
    Select Case lang
        Case "de" ' Sekunde -> Sekunden
            secondsPluralSuffix = "n"
        Case "en", "fr", "es", "pt", "it", "nl", "sv", "da", "no"
            secondsPluralSuffix = "s"
        Case Else
            secondsPluralSuffix = "" ' Fallback: kein simples Suffix
    End Select
End Code

<div class="container mt-4">
    <div class="card" style="max-width: 900px; margin: auto;">
        <div class="card-header">
            <h4 class="mb-0">@ViewData("Title")</h4>
        </div>
        <div class="card-body">
            <p class="lead">@Strings.WOLResultForSAMLUserResult_Hallo <strong>@Model.UserName</strong>, @Strings.WOLResultForSAMLUserResult_request</p>
            <hr />

            @* Show Successful Requests *@
            @If Model.SuccessMessages.Any() Then
                @<div class="alert alert-success">
                    <h5 class="alert-heading">@Strings.WOLResultForSAMLUserResult_SuccessTitle</h5>
                    <p>@Strings.WOLResultForSAMLUserResult_SuccessMessage</p>
                    <ul class="mb-0" id="success-pc-list">
                        @For Each pcName In Model.SuccessMessages
                            @<li data-pc="@pcName">
                                <strong>@pcName</strong>
                                <span class="badge bg-secondary ping-status" data-pc="@pcName">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    @Strings.PingStatus_Checking
                                </span>
                            </li>
                        Next
                    </ul>

                </div>
            End If

            @* Show Failed Requests *@
            @If Model.ErrorMessages.Any() Then
                @<div class="alert alert-danger">
                    <h5 class="alert-heading">@Strings.WOLResultForSAMLUserResult_ErrorTitle</h5>
                    <p>@Strings.WOLResultForSAMLUserResult_ErrorMessage</p>
                    <ul class="mb-0" id="error-pc-list">
                        @For Each errorMsg In Model.ErrorMessages
                            @<li data-pc="@errorMsg.Split(":"c)(0).Trim()">
                                @errorMsg
                                <span class="badge bg-secondary ping-status" data-pc="@errorMsg.Split(":"c)(0).Trim()">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    @Strings.PingStatus_Checking
                                </span>
                            </li>
                        Next
                    </ul>
                </div>
            End If

            @* Show a message if nothing happened (e.g., no PCs assigned) *@
            @If Not Model.SuccessMessages.Any() AndAlso Not Model.ErrorMessages.Any() Then
                @<div class="alert alert-danger">
                    <h5 class="alert-heading">@Strings.WOLResultForSAMLUserResult_NoActions_Title</h5>
                    <p>@Strings.WOLResultForSAMLUserResult_NoActions</p>
                    <p>
                        @Html.ActionLink(Strings.Login_StartWakeup, "Login", "Auth", Nothing, New With {.class = "btn btn-primary btn-lg w-100 mt-2"})
                    </p>
                </div>
            End If

            @* Ping Status Monitor Section *@
            @If Model.SuccessMessages.Any() OrElse Model.ErrorMessages.Any() Then
                @<div class="mt-3">
                    <div class="card bg-light border-0">
                        <div class="card-body py-2">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <small class="text-muted">
                                        <i class="fas fa-heartbeat me-1"></i>
                                        <strong>@Strings.PingMonitor_Title</strong>
                                    </small>
                                    <span id="ping-countdown"
                                          data-text-nextin="@Strings.PingMonitor_NextCheckIn"
                                          data-text-checking="@Strings.PingMonitor_CheckingNow"
                                          data-text-allonline="@Strings.PingMonitor_AllOnline"
                                          data-text-online="@Strings.PingStatus_Online"
                                          data-text-offline="@Strings.PingStatus_Offline"
                                          data-text-error="@Strings.PingStatus_Error"
                                          data-seconds-suffix="@secondsPluralSuffix"
                                          class="ms-2 text-primary">
                                        <small><i class="fas fa-spinner fa-spin me-1"></i>@Strings.PingStatus_Checking</small>
                                    </span>
                                </div>
                            </div>
                            <div class="mt-2">
                                <small class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>
                                    <em>@Strings.PingMonitor_ICMPNote</em>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            End If
        </div>

        <div class="card-footer bg-light text-end">
            @* --- LOGOUT BUTTON ADDED HERE --- *@
            @Using (Html.BeginForm("Logout", "Home", FormMethod.Post, New With {.class = "d-inline"}))
                @Html.AntiForgeryToken()

               @<button type="submit" class="btn btn-outline-danger">
                    <i class="fas fa-sign-out-alt me-1"></i> Logout
                </button>
            End Using
        </div>
    </div>
</div>

@Section scripts
    <script type="text/javascript">
 $(document).ready(function () {
      // Object to track which PCs are already online (to stop checking them)
  var onlinePCs = {};
       var countdownSeconds = 5;
     var countdownInterval = null;

  // Collect all PC names to check
  var pcNamesToCheck = [];

       // Get PCs from success list
 $('#success-pc-list li').each(function () {
         var pcName = $(this).data('pc');
  if (pcName) {
         pcNamesToCheck.push(pcName);
   }
  });

        // Get PCs from error list
$('#error-pc-list li').each(function () {
        var pcName = $(this).data('pc');
if (pcName) {
         pcNamesToCheck.push(pcName);
     }
   });

     // Get localized strings from data attributes
  var textNextIn = $('#ping-countdown').data('text-nextin');
  var textChecking = $('#ping-countdown').data('text-checking');
  var textAllOnline = $('#ping-countdown').data('text-allonline');
  var textOnline = $('#ping-countdown').data('text-online');
      var textOffline = $('#ping-countdown').data('text-offline');
          var textError = $('#ping-countdown').data('text-error');

    // Sprachabhngiges Sekunden-Plural-Suffix vom Server
    var secondsPluralSuffix = $('#ping-countdown').data('seconds-suffix') || '';

    // Function to update countdown display
 function updateCountdown() {
          if (countdownSeconds > 0) {
     var pluralMarker = countdownSeconds !== 1 ? secondsPluralSuffix : '';
       var message = textNextIn.replace('{0}', countdownSeconds).replace('{1}', pluralMarker);
       $('#ping-countdown').html('<small><i class="fas fa-clock me-1"></i>' + message + '</small>');
     } else {
       $('#ping-countdown').html('<small><i class="fas fa-sync fa-spin me-1"></i><strong class="text-info">' + textChecking + '</strong></small>');
 }
}

            // Function to reset countdown
 function resetCountdown() {
       countdownSeconds = 5;
  updateCountdown();
      }

  // Function to start countdown timer
            function startCountdownTimer() {
      if (countdownInterval) {
  clearInterval(countdownInterval);
   }

       countdownInterval = setInterval(function () {
    countdownSeconds--;
 updateCountdown();

       if (countdownSeconds < 0) {
  countdownSeconds = 5; // Reset for next cycle
       }
       }, 1000);
  }

         // Function to check ping status of a single PC
     function checkPCStatus(pcName) {
       // Skip if already online
          if (onlinePCs[pcName]) {
  return;
  }

 $.ajax({
  url: '@Url.Action("CheckPCPingStatus", "Home")',
     type: 'GET',
  data: { pcName: pcName },
   success: function (data) {
     if (data && data.pcName) {
           var badge = $('.ping-status[data-pc="' + data.pcName + '"]');

        if (data.isOnline) {
  // PC is online
      badge.removeClass('bg-secondary bg-warning bg-danger')
       .addClass('bg-success')
   .html('<i class="fas fa-check-circle"></i> ' + textOnline);

       // Mark as online so we stop checking it
       onlinePCs[data.pcName] = true;
    } else {
              // PC is offline
            badge.removeClass('bg-secondary bg-success bg-danger')
    .addClass('bg-warning')
 .html('<i class="fas fa-times-circle"></i> ' + textOffline);
  }
      }
  },
     error: function () {
         var badge = $('.ping-status[data-pc="' + pcName + '"]');

         // Prfen, ob der PC in der Error-Liste ist
         var isInErrorList = $('#error-pc-list li[data-pc="' + pcName + '"]').length > 0;

         if (isInErrorList) {
             // Nur in Error-Liste ROT anzeigen
             badge.removeClass('bg-secondary bg-success bg-warning')
                 .addClass('bg-danger')
                 .html('<i class="fas fa-exclamation-triangle"></i> ' + textError);
         } else {
             // In Success-Liste GELB anzeigen (nicht erreichbar = offline)
             badge.removeClass('bg-secondary bg-success bg-danger')
                 .addClass('bg-warning')
                 .html('<i class="fas fa-times-circle"></i> ' + textOffline);
         }
     }
       });
}

    // Function to check all PCs
function checkAllPCs() {
    // Show "Checking now..." in countdown
        countdownSeconds = 0;
   updateCountdown();

       pcNamesToCheck.forEach(function (pcName) {
      checkPCStatus(pcName);
  });

     // Reset countdown after checks complete
  setTimeout(function () {
   resetCountdown();
        }, 1000);
 }

     // Initial check immediately
  if (pcNamesToCheck.length > 0) {
    // Start countdown timer
 startCountdownTimer();

         checkAllPCs();

      // Then check every 5 seconds
 var pingInterval = setInterval(function () {
            // Check if all PCs are online
       var allOnline = pcNamesToCheck.every(function (pcName) {
     return onlinePCs[pcName] === true;
  });

     if (allOnline) {
      // All PCs are online, stop checking
  clearInterval(pingInterval);
   clearInterval(countdownInterval);
   $('#ping-countdown').html('<small><i class="fas fa-check-circle text-success me-1"></i><strong class="text-success">' + textAllOnline + '</strong></small>');
   } else {
// Continue checking
  checkAllPCs();
  }
    }, 5000); // Every 5 seconds

   // Cleanup on page unload
   $(window).on('beforeunload', function () {
  clearInterval(pingInterval);
  clearInterval(countdownInterval);
  });
        } else {
  // No PCs to check, hide countdown
     $('#ping-countdown').parent().parent().hide();
 }
  });
    </script>
End Section