@Imports Resources
@ModelType WEBPortal.ProcessWOLForSAMLUserViewModel
@Code
    ViewData("Title") = Strings.ProcessingWOLForSAMLUser_Title
    Layout = "~/Views/Shared/_Layout.vbhtml"
End Code

<div class="container mt-5">
    <div class="card" style="max-width: 800px; margin: auto;">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">@ViewData("Title")</h4>
        </div>
        <div class="card-body text-center">
            <div class="my-4">
                <div class="spinner-border text-primary" role="status" style="width: 4rem; height: 4rem;">
                    <span class="visually-hidden">@Strings.Loading_VisuallyHidden</span>
                </div>
            </div>
            
            <h5 class="my-3">@Strings.ProcessingWOLForSAMLUser_Wait</h5>
            
            <p class="mb-3">
                @Strings.ProcessingWOLForSAMLUser_Sending
            </p>
            
            <div class="alert alert-info">
                <ul class="list-unstyled mb-0">
                    @For Each pcName In Model.PCs
                        @<li><i class="fas fa-desktop me-2"></i> @pcName</li>
                    Next
                </ul>
            </div>
            
            <p class="text-muted mt-3">
                @Strings.ProcessingWOLForSAMLUser_Info
                <br>@Strings.ProcessingWOLForSAMLUser_Redirect
            </p>
        </div>
        <div class="card-footer bg-light">
            <div class="progress" style="height: 5px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 100%"></div>
            </div>
        </div>
    </div>
</div>

@Section scripts
    <script type="text/javascript">
        $(document).ready(function () {
            // Check status every 2 seconds
            var statusCheck = setInterval(function () {
                $.ajax({
                    url: '@Url.Action("CheckWOLStatus", "Home", New With {.userName = Model.UserName})',
                    type: 'GET',
                    success: function (data) {
                        if (data.completed) {
                            clearInterval(statusCheck);
                            window.location.href = '@Url.Action("WolResult", "Home")';
                        }
                    },
                    error: function () {
                        // On error, still redirect after a timeout (fallback)
                        setTimeout(function () {
                            clearInterval(statusCheck);
                            window.location.href = '@Url.Action("WolResult", "Home")';
                        }, 10000); // 10 seconds fallback timeout
                    }
                });
            }, 2000);

            // Fallback redirect after 30 seconds regardless of status
            setTimeout(function () {
                clearInterval(statusCheck);
                window.location.href = '@Url.Action("WolResult", "Home")';
            }, 30000);
        });
    </script>
End Section