﻿@Imports Resources
@ModelType WEBPortal.WolViewModel

<style>
    /* Stabil: Spalten springen nicht, Spalte 2 erhält Restfläche */
    #wol-table {
        table-layout: fixed;
        width: 100%;
    }

    /* Spalte 1 linksbündig, ohne Umbruch; Text ggf. mit Ellipsis */
    .pc-name-header, .pc-name-cell {
        text-align: left;
        white-space: nowrap;
    }

    .pc-name-text {
        display: inline-block;
        max-width: 100%;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: bottom;
    }

    /* Spalte 2 linksbündig */
    .status-action-cell {
        text-align: left;
    }

    .pc-status-badge {
        position: relative;
        display: flex;
        align-items: center;
        gap: .35rem;
        max-width: 100%;
    }

    /* Backend-Meldungen: 2 Zeilen clamp */
    .backend-msg {
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
        overflow: hidden;
        white-space: normal;
        max-width: 560px;
        line-height: 1.15;
        cursor: help;
    }

        .backend-msg:hover {
            background: rgba(0,0,0,.05);
            border-radius: 3px;
        }

    /* Auf grünem Hintergrund alles in Weiß, inkl. Backend-Suffix */
    .pc-status-badge.bg-success {
        color: #fff;
    }

        .pc-status-badge.bg-success .backend-msg {
            color: #fff !important;
        }

    /* globaler Ping-Info-Bereich */
    #global-ping-info {
        border-top: 1px dashed #e0e0e0;
    }
</style>

<div class="container-fluid mt-4">
    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">@Strings.Wol_Title</h4>
        </div>
        <div class="card-body">
            <h5 class="card-title">@Strings.Wol_AssignedComputers</h5>
            <p class="card-text text-muted">@Strings.Wol_AssignedComputersInfo</p>

            <div class="table-responsive">
                <table id="wol-table" class="table table-hover align-middle">
                    <colgroup>
                        <col id="colPcName" />
                        <col id="colStatusAction" />
                    </colgroup>
                    <thead class="table-light">
                        <tr>
                            <th class="pc-name-header">@Strings.Wol_ComputerName</th>
                            <th>@Strings.Wol_StatusAction</th>
                        </tr>
                    </thead>
                    <tbody>
                        @For Each pc In Model.PcList
                            @<tr data-pc-name="@pc.PcName" data-pc-id="@pc.PcId">
                                <td class="pc-name-cell">
                                    <strong class="pc-name-text">@pc.PcName</strong>
                                </td>
                                <td class="status-action-cell">
                                    @If pc.ShowWakeButton Then
                                        @Using Html.BeginForm("WOLPC", "Home", FormMethod.Post, New With {.class = "d-inline"})
                                            @Html.AntiForgeryToken()
                                            @Html.Hidden("pcID", pc.PcId)
                                            @Html.Hidden("user", Model.LoginName)





                                           @<button type="submit" class="btn btn-sm btn-primary">
                                                <i class="fas fa-power-off me-1"></i> @Strings.Wol_WakeComputer
                                            </button>
                                        End Using
                                    Else
                                        @<span class="badge @pc.DisplayStatusClass fs-6 p-2 pc-status-badge">
                                            @pc.DisplayStatusText <span class="backend-msg text-muted">@BackendSuffix(pc.BackendStatus)</span>
                                        </span>
                                    End If
                                </td>
                            </tr>
                        Next
                        @If Not Model.PcList.Any() Then
                            @<tr>
                                <td colspan="2" class="text-center text-muted fst-italic py-3">@Strings.Wol_NoComputersAssigned</td>
                            </tr>
                        End If
                    </tbody>
                </table>
            </div>

            <!-- Globaler PING-Countdown -->
            <div id="global-ping-info" class="mt-3 small text-muted d-none">
                <i class="fas fa-network-wired me-1"></i>
                <span id="globalPingText" class="fw-bold"></span>
            </div>
        </div>

        @* --- FOOTER WITH ALL ACTION BUTTONS --- *@
        <div class="card-footer bg-light d-flex justify-content-between align-items-center">
            <div>
                @If Model.IsWOLPortalAdmin Then
                    @Html.ActionLink(Strings.Wol_ManageUsersPCs, "Manage", New With {.userID = Model.UserID}, New With {.class = "btn btn-outline-secondary btn-sm me-2"})
                End If
                @If Model.IsGroupDataReader Then
                    @Html.ActionLink(Strings.Wol_ShowGroupStatus, "ShowGroupStatus", New With {.userID = Model.UserID}, New With {.class = "btn btn-outline-info btn-sm"})
                End If
            </div>

            <div>
                @Using (Html.BeginForm("Logout", "Home", FormMethod.Post, New With {.class = "d-inline"}))
                    @Html.AntiForgeryToken()





                   @<button type="submit" class="btn btn-sm btn-outline-danger">
                        <i class="fas fa-sign-out-alt me-1"></i> @Strings.Wol_Logout
                    </button>
                End Using
            </div>
        </div>
    </div>
</div>

@Functions
    Private Function BackendSuffix(backend As String) As String
        If String.IsNullOrWhiteSpace(backend) Then Return String.Empty
        If backend.Trim().Equals("Success", System.StringComparison.OrdinalIgnoreCase) Then Return String.Empty
        Return " - " & backend
    End Function
End Functions

@Code
    Dim wolStatusUrl = Url.Action("CheckWOLStatusPortalUser_async", "Home")

    ' Sprachabhängiges Plural-Suffix für "Sekunde{1}"/"second{1}"
    Dim lang = System.Threading.Thread.CurrentThread.CurrentUICulture.TwoLetterISOLanguageName.ToLowerInvariant()
    Dim secondsSuffix As String
    Select Case lang
        Case "de" ' Sekunde -> Sekunden
            secondsSuffix = "n"
        Case "en", "fr", "es", "pt", "it", "nl", "sv", "da", "no"
            secondsSuffix = "s"
        Case Else
            secondsSuffix = "" ' Unbekannt/keine einfache Suffix-Regel
    End Select

    ' Lokalisierte Texte für das Script serialisieren
    Dim i18nJson = (New System.Web.Script.Serialization.JavaScriptSerializer()).Serialize(
        New With {
            .PingStatus_Online = Strings.PingStatus_Online,
            .PingStatus_Offline = Strings.PingStatus_Offline,
            .PingStatus_Checking = Strings.PingStatus_Checking,
            .PingStatus_Error = Strings.PingStatus_Error,
            .PingMonitor_NextCheckIn = Strings.PingMonitor_NextCheckIn,
            .PingMonitor_AllOnline = Strings.PingMonitor_AllOnline,
            .PingMonitor_CheckingNow = Strings.PingMonitor_CheckingNow,
            .PingMonitor_Title = Strings.PingMonitor_Title,
            .PingMonitor_ICMPNote = Strings.PingMonitor_ICMPNote,
            .SecondsPluralSuffix = secondsSuffix
         }
     )
End Code

@Section scripts
    <script type="text/javascript">
    $(document).ready(function () {
        var I18N = @Html.Raw(i18nJson);

        // -------- Utilities --------
        function debounce(fn, wait) { var t; return function () { clearTimeout(t); t = setTimeout(fn, wait); }; }
        function format(str) {
            var args = Array.prototype.slice.call(arguments, 1);
            return (str || '').replace(/\{(\d+)\}/g, function (m, i) {
                return typeof args[i] !== 'undefined' ? args[i] : m;
            });
        }

        function initTooltips() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.forEach(function (el) {
                if (el._tooltipInstance) { el._tooltipInstance.dispose(); }
                el._tooltipInstance = new bootstrap.Tooltip(el);
            });
        }

        function fixNameColumnWidth() {
            var table = document.getElementById('wol-table');
            if (!table) return;

            var tableW = table.getBoundingClientRect().width;
            var MIN_PX = 140;
            var MAX_PCT = 0.35;
            var MAX_PX = Math.max(220, Math.floor(tableW * MAX_PCT));
            var maxContent = 0;

            var samples = table.querySelectorAll('tbody td.pc-name-cell .pc-name-text');
            samples.forEach(function (el) { maxContent = Math.max(maxContent, el.getBoundingClientRect().width); });
            var head = table.querySelector('thead .pc-name-header');
            if (head) maxContent = Math.max(maxContent, head.getBoundingClientRect().width);

            var anyCell = table.querySelector('tbody td.pc-name-cell') || head;
            var paddingX = 24;
            if (anyCell) {
                var cs = window.getComputedStyle(anyCell);
                paddingX = parseFloat(cs.paddingLeft) + parseFloat(cs.paddingRight) +
                           parseFloat(cs.borderLeftWidth) + parseFloat(cs.borderRightWidth);
            }

            var desired = Math.ceil(maxContent + paddingX + 8);
            var finalWidth = Math.max(MIN_PX, Math.min(MAX_PX, desired));
            $('#colPcName').css('width', finalWidth + 'px');

            table.querySelectorAll('tbody td.pc-name-cell .pc-name-text').forEach(function (el) {
                el.style.maxWidth = (finalWidth - paddingX - 8) + 'px';
                if (el.scrollWidth > el.clientWidth) {
                    el.setAttribute('data-bs-toggle', 'tooltip');
                    el.setAttribute('data-bs-placement', 'top');
                    el.setAttribute('title', el.textContent.trim());
                } else {
                    el.removeAttribute('title');
                    if (el._tooltipInstance) { el._tooltipInstance.dispose(); el._tooltipInstance = null; }
                }
            });

            initTooltips();
        }

        fixNameColumnWidth();
        $(window).on('load', fixNameColumnWidth);
        $(window).on('resize', debounce(fixNameColumnWidth, 150));

        // ----------------- Globales PING-Scheduling -----------------
        var checkIntervalSeconds = 5;             // Takt für alle Pings
        var nextPingIn = checkIntervalSeconds;    // globaler Countdown
        var countdownTimer = null;

        // Monitoring-State je PC
        var pcStates = {}; // name -> { pcId, isOnline, backendMsg, $row, $badge }

        // Woken-Liste aus ViewBag
        var lastWokenPCs = [];
        @Code                       Dim wokenList = TryCast(ViewBag.WokenPCs, IEnumerable(Of String))
        End Code
        @If wokenList IsNot Nothing Then
            @For Each pcName As String In wokenList
                @:lastWokenPCs.push('@pcName');
            Next
        End If

        // falls nichts zu überwachen ist, Ende
        if (lastWokenPCs.length === 0) {
            return;
        }

        function ensureBadge($row) {
            var $badge = $row.find('.pc-status-badge');
            if ($badge.length === 0) {
                var $buttonCell = $row.find('td:last');
                $buttonCell.html('<span class="badge bg-warning text-dark fs-6 p-2 pc-status-badge"></span>');
                $badge = $buttonCell.find('.pc-status-badge');
            }
            return $badge;
        }

        function appendBackendSuffix(state) {
            var $badge = state.$badge;
            $badge.find('.backend-msg').remove();
            if (!state.backendMsg) return;
            var full = state.backendMsg.replace(/^ - /, '');
            var colorClass = $badge.hasClass('bg-success') ? 'text-white' : 'text-muted';
            var $suffix = $('<span/>', {
                'class': 'backend-msg ms-1 ' + colorClass,
                'data-bs-toggle': 'tooltip',
                'data-bs-placement': 'top',
                'title': full
            }).text(state.backendMsg);
            $badge.append($suffix);
        }

        function renderRow(state) {
            var $b = state.$badge;
            $b.removeClass('bg-secondary bg-info bg-success bg-danger bg-warning text-dark text-white');
            if (state.isOnline) {
                $b.addClass('bg-success');
                $b.html('<i class="fas fa-check-circle"></i> ' + I18N.PingStatus_Online);
            } else {
                // Nur OFFLINE, keine Zeilen-spezifische Countdown-Anzeige
                $b.addClass('bg-warning text-dark');
                $b.html('<strong>' + I18N.PingStatus_Offline + '</strong>');
            }
            appendBackendSuffix(state);
        }

        function pollBackendFor(state) {
            if (!state || state._backendInFlight) return;
            state._backendInFlight = true;
            $.ajax({
                url: '@Url.Action("CheckWOLStatusPortalUser_async", "Home")',
                type: 'GET',
                data: { pcID: state.pcId },
                cache: false,
                timeout: 4500
            })
            .done(function (text) {
                var t = (text || '').trim();
                var newMsg = t ? ' - ' + t : '';
                if (newMsg !== state.backendMsg) {
                    state.backendMsg = newMsg;
                    renderRow(state);
                    initTooltips();
                }
            })
            .always(function () { state._backendInFlight = false; });
        }

        function pingAllNotOnline() {
            var pending = Object.values(pcStates).filter(function(s) { return !s.isOnline; });
            if (pending.length === 0) return;

            pending.forEach(function (state) {
                if (state._pingInFlight) return;
                state._pingInFlight = true;

                $.ajax({
                    url: '@Url.Action("CheckPCPingStatus", "Home")',
                    type: 'GET',
                    data: { pcName: state.name },
                    cache: false,
                    timeout: 4500
                })
                .done(function (data) {
                    if (data && data.isOnline) {
                        state.isOnline = true;
                    }
                    // In beiden Fällen neu zeichnen (ändert Textfarbe/Badge)
                    renderRow(state);
                })
                .fail(function () {
                    // Fehler: wir bleiben bei OFFLINE-Anzeige
                })
                .always(function () {
                    state._pingInFlight = false;
                    // Backend am selben Takt abrufen
                    pollBackendFor(state);
                });
            });
        }

        function anyNotOnline() {
            return Object.values(pcStates).some(function (s) { return !s.isOnline; });
        }

        var $globalInfo = $('#global-ping-info');
        var $globalText = $('#globalPingText');

        function setGlobalCheckingNow() {
            $globalText.text(I18N.PingMonitor_CheckingNow || '');
        }

        function setGlobalNextCheck(seconds) {
            if (I18N.PingMonitor_NextCheckIn && I18N.PingMonitor_NextCheckIn.indexOf('{0}') !== -1) {
                var suffix = (seconds === 1) ? '' : (I18N.SecondsPluralSuffix || '');
                $globalText.text(format(I18N.PingMonitor_NextCheckIn, seconds, suffix));
            } else {
                // Fallback: einfache Darstellung ohne Sprachkomplexität
                var suffix = (seconds === 1) ? '' : (I18N.SecondsPluralSuffix || 's');
                $globalText.text((I18N.PingMonitor_NextCheckIn || 'Next check in:') + ' ' + seconds + suffix);
            }
        }

        var countdownTimer = null;
        var checkIntervalSeconds = 5;
        var nextPingIn = checkIntervalSeconds;

        function startGlobalScheduler() {
            // Globalen Bereich nur zeigen, wenn es noch OFFLINE-Geräte gibt
            if (anyNotOnline()) {
                $globalInfo.removeClass('d-none');
            } else {
                $globalInfo.addClass('d-none');
            }

            if (countdownTimer) clearInterval(countdownTimer);
            nextPingIn = checkIntervalSeconds;
            setGlobalNextCheck(nextPingIn);

            countdownTimer = setInterval(function () {
                // Wenn niemand mehr offen ist: Bereich ausblenden und Timer stoppen
                if (!anyNotOnline()) {
                    $globalInfo.addClass('d-none');
                    clearInterval(countdownTimer);
                    return;
                }

                nextPingIn--;
                if (nextPingIn <= 0) {
                    setGlobalCheckingNow();
                    pingAllNotOnline();            // alle gleichzeitig prüfen
                    nextPingIn = checkIntervalSeconds;
                }
                setGlobalNextCheck(nextPingIn);
            }, 1000);
        }

        // Registrierung der zu überwachenden PCs (nur einmal)
        lastWokenPCs.forEach(function (pcName) {
            var $row = $('tr[data-pc-name="' + pcName + '"]');
            var $badge = ensureBadge($row);
            var pcId = $row.data('pc-id');

            pcStates[pcName] = {
                name: pcName,
                pcId: pcId,
                isOnline: false,
                backendMsg: "",
                $row: $row,
                $badge: $badge
            };

            // Initiale Darstellung (OFFLINE ohne individuellen Countdown)
            renderRow(pcStates[pcName]);
        });

        // ersten Ping-Zyklus kurz nach Start ausführen
        setTimeout(function () { pingAllNotOnline(); }, 400);

        // globalen Scheduler starten
        startGlobalScheduler();

        // Aufräumen
        $(window).on('beforeunload', function () {
            if (countdownTimer) clearInterval(countdownTimer);
        });

        initTooltips();
    });
    </script>
End Section