﻿@Imports Resources
@ModelType UserPoco

<style>
    /* Override der globalen 280px-Begrenzung aus Site.css nur für dieses Formular */
    .login-portal input,
    .login-portal select,
    .login-portal textarea {
        max-width: 100% !important;
    }

    .login-portal .form-control {
        width: 100%;
    }

    .login-portal .btn {
        width: 100%;
    }
</style>

@Using (Html.BeginForm(Nothing, Nothing, FormMethod.Post, New With {.class = "login-portal"}))
    @Html.AntiForgeryToken()
    @Html.ValidationSummary(True, "", New With {.class = "text-danger"})


   @<div class="form-floating mb-3">
        @Html.TextBoxFor(Function(m) m.LoginName, New With {.class = "form-control", .placeholder = Strings.LoginForm_UsernamePlaceholder})
        @Html.LabelFor(Function(m) m.LoginName, Strings.LoginForm_UsernameLabel)
        @Html.ValidationMessageFor(Function(m) m.LoginName, "", New With {.class = "text-danger small"})
    </div>


   @<div class="form-floating mb-3">
        @Html.PasswordFor(Function(m) m.pw, New With {.class = "form-control", .placeholder = Strings.LoginForm_PasswordPlaceholder})
        @Html.LabelFor(Function(m) m.pw, Strings.LoginForm_PasswordLabel)
        @Html.ValidationMessageFor(Function(m) m.pw, "", New With {.class = "text-danger small"})
    </div>


   @<div class="d-grid">
        <input type="submit" value="@Strings.LoginForm_Submit" class="btn btn-secondary btn-lg" />
    </div>  End Using