﻿@Imports Resources
@ModelType System.Web.Mvc.HandleErrorInfo
@Code
    ' Use the simple, failsafe layout
    Layout = "~/Views/Shared/_ErrorLayoutSimple.vbhtml"
    ViewBag.Title = Strings.AppError_Title
End Code

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-10 col-lg-8">

            @* ========================================================== *@
     @*  THIS IS THE CARD EVERYONE SEES (USERS AND DEVELOPERS)     *@
            @* ========================================================== *@
      <div class="card shadow-sm">
        <div class="card-header bg-danger text-white">
            <h1 class="display-4">@Strings.AppError_Title</h1>
       </div>
          <div class="card-body text-center">
      <p class="lead">@Strings.AppError_Lead</p>
  <hr class="my-4" />
 <p>@Strings.AppError_ContactSupport</p>

         @* Display the Unique Error ID from the ViewBag *@
        <div class="alert alert-info d-inline-block">
        <strong>@Strings.AppError_Reference</strong> @ViewBag.ErrorId
  </div>

            <div class="mt-4">
 @Html.ActionLink(Strings.AppError_HomeButton, "Wol", "Home", Nothing, New With {.class = "btn btn-primary btn-lg"})
  </div>
             </div>
           <div class="card-footer text-muted">
                @Strings.AppError_Footer
      </div>
            </div>

            @* ========================================================== *@
   @*  THIS SECTION IS ONLY VISIBLE TO DEVELOPERS ON LOCALHOST   *@
    @* ========================================================== *@
            @If Request.IsLocal AndAlso Model IsNot Nothing Then
         @<div class="alert alert-warning mt-4 text-start">
          <h4 class="alert-heading">Developer Diagnostic Information (Visible on Localhost Only)</h4>
     <hr>
 <p>
         <strong>Error Reason (Message):</strong>
          <br />
      <span class="text-danger">@Model.Exception.Message</span>
  </p>
           <p>
           <strong>Error Location:</strong>
  <br />
 An exception of type <code>@Model.Exception.GetType().FullName</code> occurred in the
            <code>@Model.ControllerName</code> controller's <code>@Model.ActionName</code> action.
            </p>
         <hr>
   <strong>Full Stack Trace:</strong>
       <pre style="white-space: pre-wrap; word-wrap: break-word;">@Model.Exception.ToString()</pre>
      </div>
            End If

        </div>
    </div>
</div>