﻿<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@ViewBag.Title - WOL Portal</title>

    @Styles.Render("~/Content/css")
    @Scripts.Render("~/bundles/modernizr") @* Modernizr is fine to leave here *@
    @RenderSection("Styles", required:=False)

</head>
<body>
    <!-- This is a modern, responsive Bootstrap 5 Navbar.
         You can change 'bg-light' and 'navbar-light' to 'bg-dark' and 'navbar-dark' for a dark theme. -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom mb-3">
        <div class="container-fluid">
            <!-- The standard 'navbar-brand' for your logo -->
            <a class="navbar-brand" href="@Url.Action("Wol", "Home")">
                <img src="~/Images/logo150px.png" alt="EnviProt Logo" width="150" class="d-inline-block align-text-top">
            </a>

            <!-- The welcome text -->
            <span class="navbar-text flex-grow-1 text-center" style="font-size:x-large; color:slategray;">
                <b>Welcome to the WOL Portal</b>
            </span>

            <!-- Language selection dropdown -->
            <div class="dropdown ms-auto">
                <button class="btn btn-secondary dropdown-toggle" type="button" id="languageDropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                    Language
                </button>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="languageDropdownMenuButton">
                    <li><a class="dropdown-item" href="@Url.Action("SetLanguage", "Home", New With {.language = "en"})">English</a></li>
                    <li><a class="dropdown-item" href="@Url.Action("SetLanguage", "Home", New With {.language = "de"})">Deutsch</a></li>
                    <li><a class="dropdown-item" href="@Url.Action("SetLanguage", "Home", New With {.language = "es"})">Español</a></li>
                    <li><a class="dropdown-item" href="@Url.Action("SetLanguage", "Home", New With {.language = "fr"})">Français</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container body-content">
        @RenderBody()
        <hr />

        <footer>
            <p>© @DateTime.Now.Year - EnviProt - The Power Saving Company, Version: @GetType(WEBPortal.HomeController).Assembly.GetName().Version.ToString()</p>
        </footer>
    </div>

</body>
@* --- FINAL FIX: Replace the crashing bundles with direct script tags --- *@
<script src="~/Scripts/jquery-3.7.1.min.js"></script>
<script src="~/Scripts/bootstrap.bundle.min.js"></script>

@RenderSection("scripts", required:=False)
</html>