window.auth = window.auth || {};

window.auth.issueCookie = async function (ticket) {
    try {
        const form = new FormData();
        form.append('ticket', ticket);
        const resp = await fetch('/auth/issue-cookie', {
            method: 'POST',
            body: form,
            credentials: 'include'
        });
        return resp.ok;
    } catch (e) {
        console.error('issueCookie failed', e);
        return false;
    }
}

window.auth.loginLdap = async function (userName, password) {
    try {
        const form = new FormData();
        form.append('userName', userName);
        form.append('password', password);
        const resp = await fetch('/auth/ldap-login', {
            method: 'POST',
            body: form,
            credentials: 'include'
        });
        return resp.ok;
    } catch (e) {
        console.error('loginLdap failed', e);
        return false;
    }
}
